!Object constantsFor: 'Geos Libraries'!

geosLIB12 'SYSTEM\compose'! !

!Object constantsFor: 'Geos vardata'!

!

!Object constantsFor: 'Geos messages'!

initiate 27648!
close 27649!
edit 27650!
play 27651!
back 27652!
ctrlClear 27653!
clearDialogReset 27654!
undoDialogReset 27655!
undoDialogSet 27656!
vpEciReceive 27657!
test 27658!
getOta 27659!
otaOpen 27660!
saveOk 27661!
findTuneName 27662!
oneNotePlay 27663!
oneNoteToString 27664!
playFromButton 27665!
stopFromButton 27666!
updateName 27667!
!

!Geos class methodsFor: 'library calls'!

!

GenControl subclass: #ComposeControl
	instanceVariableNames: ''
	classVariableNames: ''!

!ComposeControl comment!
Library compose, file internal/resp/compose.goh! !

!ComposeControl class methodsFor: 'library linkage'!

library
	^12!

entry
	^0000!
!

!ComposeControl methodsFor: 'Geos instance variables'!

cciVisObject
	"@instance optr CCI_visObject"
	^self dwordAt: 25!

cciVisObject: value
	"@instance optr CCI_visObject"
	^self dwordAt: 25 put: value!

cciUndoDialogOptr
	"@instance optr CCI_undoDialogOptr"
	^self dwordAt: 29!

cciUndoDialogOptr: value
	"@instance optr CCI_undoDialogOptr"
	^self dwordAt: 29 put: value!

cciClearDialogOptr
	"@instance optr CCI_clearDialogOptr"
	^self dwordAt: 33!

cciClearDialogOptr: value
	"@instance optr CCI_clearDialogOptr"
	^self dwordAt: 33 put: value!

!

!ComposeControl methodsFor: 'Geos vardata'!

!

!ComposeControl methodsFor: 'Geos messages'!

initiate: ptFile
	"@message void MSG_CMP_INITIATE(TCHAR *ptFile )"
	^self geosMessage: #[108 0 1 0 3 0] with: ptFile!

close
	"@message void MSG_CMP_CLOSE()"
	^self geosMessage: #[108 1 2 0 0]!

edit
	"@message void MSG_CMP_EDIT()"
	^self geosMessage: #[108 2 2 0 0]!

play: bChangePlayButton
	"@message void MSG_CMP_PLAY(Boolean bChangePlayButton )"
	^self geosMessage: #[108 3 1 0 4 0] with: bChangePlayButton!

back
	"@message void MSG_CMP_BACK()"
	^self geosMessage: #[108 4 2 0 0]!

ctrlClear
	"@message void MSG_CMP_CTRL_CLEAR()"
	^self geosMessage: #[108 5 2 0 0]!

clearDialogReset
	"@message void MSG_CMP_CLEAR_DIALOG_RESET()"
	^self geosMessage: #[108 6 2 0 0]!

undoDialogReset
	"@message void MSG_CMP_UNDO_DIALOG_RESET()"
	^self geosMessage: #[108 7 2 0 0]!

undoDialogSet: dialog
	"@message void MSG_CMP_UNDO_DIALOG_SET( optr dialog)"
	^self geosMessage: #[108 8 1 0 2 0] with: dialog!

vpEciReceive: messageId with: structure
	"@message void MSG_CMP_VP_ECI_RECEIVE(word messageId ,MemHandle structure)"
	^self geosMessage: #[108 9 1 0 1 1 0] with: messageId with: structure!

test
	"@message int MSG_CMP_TEST()"
	^self geosMessage: #[108 10 2 0 4]!

getOta: ptcFile
	"@message void MSG_CMP_GET_OTA(TCHAR *ptcFile)"
	^self geosMessage: #[108 11 1 0 3 0] with: ptcFile!

otaOpen: ptcFile
	"@message void MSG_CMP_OTA_OPEN(TCHAR *ptcFile)"
	^self geosMessage: #[108 12 1 0 3 0] with: ptcFile!

saveOk: newDlg
	"@message Boolean MSG_CMP_SAVE_OK(optr newDlg)"
	^self geosMessage: #[108 13 1 0 2 4] with: newDlg!

findTuneName: hTune
	"@message MemHandle MSG_CMP_FIND_TUNE_NAME(MemHandle hTune)"
	^self geosMessage: #[108 14 1 0 1 1] with: hTune!

oneNotePlay
	"@message void MSG_CMP_ONE_NOTE_PLAY()"
	^self geosMessage: #[108 15 2 0 0]!

oneNoteToString: tone_string
	"@message int MSG_CMP_ONE_NOTE_TO_STRING(byte *tone_string)"
	^self geosMessage: #[108 16 1 0 3 4] with: tone_string!

playFromButton
	"@message void MSG_CMP_PLAY_FROM_BUTTON()"
	^self geosMessage: #[108 17 2 0 0]!

stopFromButton
	"@message void MSG_CMP_STOP_FROM_BUTTON()"
	^self geosMessage: #[108 18 2 0 0]!

updateName: ptcFileName with: boolOnMemoryCard
	"@message void MSG_CMP_UPDATE_NAME(TCHAR *ptcFileName, Boolean boolOnMemoryCard)"
	^self geosMessage: #[108 19 1 0 3 4 0] with: ptcFileName with: boolOnMemoryCard!

!

